package logica;

import exceptions.ParseHexRecordException;

public class HexRecord {
	public final static int DATA_RECORD = 0; 
	public final static int END_OF_FILE_RECORD = 1; 
	public final static int EXTENDED_SEGMENT_ADDRESS_RECORD = 2; 
	public final static int START_SEGMENT_ADDRESS_RECORD = 3; 
	public final static int EXTENDED_LINEAR_ADDRESS_RECORD = 4; 
	public final static int START_LINEAR_ADDRESS_RECORD = 5; 
	
	
	private int recLen;
	private int offset;
	private int rectype;
	private String infoOrData;
	private int chksum;
	private int bits;
	private int linearAddress;
	
	public DataHexRecord getDataHexRecord(){
		return new DataHexRecord(linearAddress,getBinData());
	}
	public DataHexRecord getDataHexRecord(int tam){
		byte[] binData = getBinData();
		byte[] data = new byte[tam];
		for (int i=0; i<tam; i++){
			data[i]=binData[i];
		}
		return new DataHexRecord(linearAddress,data);
	}
	
	public int getLinearAddress() {
		return linearAddress;
	}

	public void setLinearAddress(int linearAddress) {
		this.linearAddress = linearAddress;
	}

	public HexRecord(int bits){
		this.bits=bits;
	};
	
	public HexRecord(int len,int offset ,int rectype, String data,int chksum) {
		super();
		// TODO Auto-generated constructor stub
		this.chksum = chksum;
		infoOrData = data;
		this.offset = offset;
		recLen = len;
		this.rectype = rectype;
	}
		
	
	public byte[] getBinData(){
		byte[] sb= new byte[recLen];
		for (int i=0; i<recLen ; i++){
			sb[i] = (byte)Integer.parseInt(infoOrData.substring(i*2,i*2+2), 16);
		}
		return sb;
	}
	
	public void printBinData(){
		byte[] c=this.getBinData();
		System.out.println("en binario: ");
		for (int i=0;i<c.length;i++){
			String s = Integer.toHexString(Byte.valueOf(c[i]));
			if (s.length()>1) s = s.substring(s.length()-2);
			else s = "0"+s;
			System.out.print(s +" ");
		}
		System.out.println();
	}
	
	public void parse(String line) throws ParseHexRecordException{
//		1 verifico que tenga los 2 puntos
		if (line.charAt(0)==':'){
			recLen = Integer.parseInt(line.substring(1,3), 16);
			System.out.print("recLen: " + line.substring(1,3)+ " "+ recLen + " - ");
			offset = Integer.parseInt(line.substring(3,7), 16);
			System.out.print("offset: " + line.substring(3,7)+ " "+ offset + " - " );
			rectype = Integer.parseInt(line.substring(7,9), 16);
			System.out.print("rectype: " + line.substring(7,9)+ " "+ rectype + " - ");
			infoOrData = line.substring(9,9+recLen*2);
			System.out.print("infoOrData: " + infoOrData + " - ");
			chksum = Integer.parseInt(line.substring(line.length()-2,line.length()), 16);
			System.out.print("checksum: " + line.substring(line.length()-2,line.length())+ " "+ chksum + " - " );
			//TODO largar excepcion si el chksum es distinto que el que calculo yo
			System.out.println("mi checksum: " + getHexString(calcChksum()) + " - " );
			
		}
		else throw new ParseHexRecordException();
	}
	
	public byte calcChksum(){
		byte mychksum = (byte)((byte)recLen + (byte)(offset % 256) + (byte)(offset/256) + (byte)rectype);
		if (infoOrData!=null){
			byte[] data= getBinData();
			for(int i=0;i<data.length;i++){
				mychksum=(byte) (mychksum+data[i]);
			}
			
		}
		return (byte)-mychksum;
	}
	
	public String getHexString(byte b){
		String s = Integer.toHexString(Byte.valueOf(b));
		if (s.length()>1) s = s.substring(s.length()-2);
		else s = "0"+s;
		return s.toUpperCase();
	}
	
	public int getChksum() {
		return chksum;
	}
	public void setChksum(int chksum) {
		this.chksum = chksum;
	}
	public String getInfoOrData() {
		return infoOrData;
	}
	public void setInfoOrData(String infoOrData) {
		this.infoOrData = infoOrData;
	}
	public int getOffset() {
		return offset;
	}
	public void setOffset(int offset) {
		this.offset = offset;
	}
	public int getRecLen() {
		return recLen;
	}
	public void setRecLen(int recLen) {
		this.recLen = recLen;
	}
	public int getRectype() {
		return rectype;
	}
	public void setRectype(int rectype) {
		this.rectype = rectype;
	}
	
}
